<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
<link rel="shortcut icon" href="/favicon.png" type="image/x-icon">
<title>BMC-85 Trust Fund | Trade Winds Surety Bond Partners</title>
<?php include 'global_scripts.php';?>
</head>
<body>
<?php include 'global_head.php';?>
<div class="tp-page-header "><!-- full page header -->
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="page-header"> <!-- page header  -->
				<div class=" col-md-7 text-left left-side">
          <h1>Trust Fund (BMC-85)</h1>
          <p class="lead col-md-12 ">Being a licensed freight broker comes with as many opportunities as it does responsibilities. In addition to meeting the needs of customers, freight brokers must comply with laws and regulations set out by the Federal Motor Carrier Safety Administration, the FMCSA. </p>
					</div>
					<div class=" col-md-4 text-center right-side"><!-- Quote box -->
          		<h1>Get Quote Today</h1>
            	<a href="/freight-broker-bond-application" class="btn tp-btn tp-btn-orange">Get a Quote</a>
          	</div><!-- /.Quote box -->

        </div>
        <!-- page header  --> 
      </div>
      <div class="col-md-5 header-pic"><!-- page header pic --></div>
      <!-- page header pic --> 
    </div>
  </div>
</div>
<!-- /.full page header-->
<div class="tp-breadcrumb">
  <div class="container">
    <div class="row">
      <div class="col-md-8">
        <ol class="breadcrumb">
          <li><a href="/">Home</a></li>
          <li><a href="/surety-bonds">Surety Bonds</a></li>
          <li class="active">BMC-85</li>
        </ol>
      </div>

    </div>
  </div>
</div>
<div class="main-container" id="main-container"><!--Main container start-->
  <div class="tp-faq" id="tp-faq"><!-- insurance section -->
    <div class="container">
      <div class="row "> 
        <!--left-->
        <div class="col-md-3 left-side nav-sidebar" id="leftCol">
        <div id="sidebar" class="hide-side">
          <ul class="nav" id="sidebar">
            <li class="active"><a href="#understand" class="">Defining a BMC-85</a></li>
            <li><a href="#cost" class="">Understanding the Cost of a BMC-85</a> </li>
            <li><a href="#breaking" class="">Securing a BMC-85</a></li>
          </ul>
        </div>
        <!--/left--> 
        </div>
        <!--right-->
        <div class="col-md-9 faq-right-side font-increase right-side">
          <div class="row">
            <div class="col-md-12 section-content" id="understand"><!-- auto insurance question -->
              <ul>
                <li>
                  <h2>Defining a BMC-85</h2>
                  <p>Under licensing guidelines, freight brokers operating in the United States are required to have a valid license which includes obtaining a form of security, either as a bond or a trust fund. The bond option, which is a <a href="/freight-broker-bonds">surety bond known as BMC-84</a>, differs from the trust option, known as the BMC-85, in several ways. Freight brokers need to understand the difference between the two types of security options so that an informed decision can be made on which is more viable for the business. Here’s what a BMC-85 means, how it works compared to a BMC-84 bond, the cost of establishing a trust fund, and the process of putting it in place.</p>
                  <p>Under federal laws, licensed freight brokers must obtain a bond or a trust fund of no less than $75,000 in order to operate their business legally. This bond or trust fund provides protection to the FMCSA, and it acts as a reserve for the freight broker to help cover future claims from customers or the public. A claim made against a freight broker is paid by the trust fund or the bond. With a BMC-85, claims are repaid to the trust to ensure the $75,000 minimum is always intact.</p>
                  <p>A BMC-85 is a freight broker trust account that holds the $75,000 requirement in cash or liquid assets. The licensed freight broker who establishes a BMC-85 places the entire amount into the trust fund when it is created, and replenishes the fund should a claim be made and paid out. The BMC-85 is managed by a trust company or custodian, such as a bank or other financial institution, and it is necessary to maintain either the fund or a bond every year a freight broker holds a valid license.</p>
                  <p>Having a BMC-85 freight broker trust differs from a BMC-84 freight broker bond in a few ways. First, a surety bond is a contract between three parties: the principal who is required to have a bond, the obligee which is the FMCSA, and the surety company. The bond amount is still $75,000, but the surety company extends a form of a credit to the freight broker to cover future claims. The funds, then, are not held in a trust like a BMC-85.</p>
                </li>
            </div>
            <!-- /.auto insurance question --> 
          </div>
          <div class="row">
            <div class="col-md-12 section-content" id="cost"><!-- auto insurance question -->
              <ul>
                <li>
				  <h2>Understanding the Cost of a BMC-85</h2>
                  <p>Freight brokers who create a BMC-85 trust fund pay the full requirement of $75,000 up front, which is a substantial cost to the broker. Trust companies and custodians of BMC-85 funds also charge annual fees, ranging anywhere from $500 up to $1,500 per year. Many freight brokers opt for obtaining a BMC-84 bond instead, because the upfront out of pocket costs are far lower.</p>
                  <p>A BMC-84 bond requires payment of only a small fraction of the total bond amount. For brokers with a healthy credit history and strong business financials, this cost is between 1 and 5% of the $75,000 FMCSA requirement. The price of a BMC-84 bond is payable each year the bond renews, unlike the single payment of the BMC-85 trust fund deposit.</p>
				  <p>It is essential to consider these costs and compare the benefits and drawbacks of each to determine if a BMC-84 or BMC-85 makes more sense for your freight brokerage.</p>
                </li>
            </div>
            <!-- /.auto insurance question --> 
          </div>
		  <div class="row">
            <div class="col-md-12 section-content" id="breaking"><!-- auto insurance question -->
				<ul>
                <li>
				  <h2>Securing a BMC-85</h2>
                  <p>If getting a BMC-85 trust fund is the best option for you as a licensed freight broker, the good news is that it is a straightforward process. There is no credit check required as there is with a BMC-84 freight broker bond, since a trust fund is not an extension of credit to your business. The entire BMC-85 amount must be funded as soon as the trust account is created.</p>
                  <p>To start the process, you need to choose a trust company or custodian, ideally one that is insured and has a stable financial footing. It may also be helpful to make a decision based on the custodian’s experience with managing BMC-85 trusts. After choosing a trust company, you make the transfer to fund the trust of either cash or other acceptable collateral. The information relating to your BMC-85 are provided to the FMCSA as a record of meeting the trust fund requirement. </p>
                </li>
				</ul>
            </div>
            <!-- /.auto insurance question --> 
          </div>
		  
        </div>
        <!--/right--> 
      </div>
      <!--/row-->
	  
	  
    </div>
  </div>
  <!-- insurance section --> 
  
  
  
</div>
<!-- /.Main container start-->
<?php include 'global_footer.php';?>