<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
<link rel="shortcut icon" href="/favicon.png" type="image/x-icon">
<title>BMC-84 Freight Broker Bond | Trade Winds Surety Bond Partners</title>
<?php include 'global_scripts.php';?>
</head>
<body>
<?php include 'global_head.php';?>
<div class="tp-page-header "><!-- full page header -->
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="page-header"> <!-- page header  -->
				<div class=" col-md-7 text-left left-side">
          <h1>Freight Broker Bond</h1>
          <p class="lead col-md-12 ">Whether you’re new to the freight industry or a seasoned broker, recognizing the need for a freight broker bond is an essential part of operating a successful business.</p>
					</div>
					<div class=" col-md-4 text-center right-side"><!-- Quote box -->
          		<h1>Apply Online</h1>
            	<a href="/freight-broker-bond-application" class="btn tp-btn tp-btn-orange tp-btn">Get Your Free Quote!</a>
          	</div><!-- /.Quote box -->

        </div>
        <!-- page header  --> 
      </div>
      <div class="col-md-5 header-pic"><!-- page header pic --></div>
      <!-- page header pic --> 
    </div>
  </div>
</div>
<!-- /.full page header-->
<div class="tp-breadcrumb">
  <div class="container">
    <div class="row">
      <div class="col-md-8">
        <ol class="breadcrumb">
          <li><a href="/">Home</a></li>
          <li><a href="/surety-bonds">Surety Bonds</a></li>
          <li class="active">Freight Broker Bond</li>
        </ol>
      </div>

    </div>
  </div>
</div>
<div class="main-container" id="main-container"><!--Main container start-->
  <div class="tp-faq" id="tp-faq"><!-- insurance section -->
    <div class="container">
      <div class="row "> 
        <!--left-->
        <div class="col-md-3 left-side nav-sidebar" id="leftCol">
        <div id="sidebar" class="hide-side">
          <ul class="nav" id="sidebar">
            <li class="active"><a href="#understand" class="">Understanding Freight Broker Bonds (BMC-84's)</a></li>
            <li><a href="#cost" class="">What Does a BMC-84 Bond Cost?</a> </li>
            <li><a href="#breaking" class="">Breaking Down BMC-84 vs. BMC-85</a></li>
            <li><a href="#process" class="">The Process for Getting a BMC-84 Bond</a></li>
          </ul>
        </div>
        <!--/left--> 
        </div>
        <!--right-->
        <div class="col-md-9 faq-right-side font-increase right-side">
          <div class="row">
            <div class="col-md-12 section-content" id="understand"><!-- auto insurance question -->
              <ul>
                <li>
                  <h2>Understanding Freight Broker Bonds (BMC-84's)</h2>
                  <p>A freight broker bond, also known as a BMC-84, is a form of security offered by a bond company to a licensed and registered freight broker. A bond is a contractual agreement between you as the bondholder, the surety agency or bond company, and the shippers and motor carriers you work with each day. Under this contract, a surety company promises to pay for legitimate claims made against the bond for the freight broker. However, these claims must be repaid by the broker over time.</p>
				  <p>BMC-84 bonds may seem like insurance on the surface, but they operate differently. Freight brokers are legally required to have a bond or other form of collateral in place, but they do not necessarily reap the benefits should an issue arise while doing their job as they might with an insurance policy. As an example, if a shipper or motor carrier is not paid per their agreement made with the broker, a claim can be filed against the bond.</p>
				  <p>The freight broker does not receive the claim amount; the shipper or motor carrier receives payment as a way to cover any financial losses they may have incurred. Then, repayment is made to the bond company by the broker. In this sense, a BMC-84 bond is like credit extended to the licensed broker by the surety agency.</p>
                </li>
            </div>
            <!-- /.auto insurance question --> 
          </div>
          <div class="row">
            <div class="col-md-12 section-content" id="cost"><!-- auto insurance question -->
              <ul>
                <li>
                  <h2>What Does a BMC-84 Bond Cost?</h2>
                  <p>A BMC-84 bond of $75,000 is required under FMCSA regulations. Fortunately, freight broker opting to use a bond for this requirement do not have the pay that entire amount up front. A broker pays just a small percentage of the $75,000 bond, typically between 1 and 12%. The range for the percentage paid is based on several different aspects of a freight broker’s business and financial picture. However, one of the most important factors is your personal credit.</p>
				  <p>Because bond claims are paid by the bond company upfront, freight brokers need to have strong credit to qualify for the least expensive BMC-84 bonds. Having bad credit, such as bankruptcies, tax liens or court judgments, missed or late payments, or heavy credit account use, is likely to be a red flag for a surety agency reviewing a bond application. This does not mean bad credit disqualifies you from getting your freight broker bond. It does mean, though, that the cost of your bond is likely to be higher.</p>
				  <p>Fortunately, a good surety agency will work with you even if credit has been an issue in the past. You can also work to improve your credit before applying for a new freight broker bond. Strong credit requires on-time payments and minimal negative marks on your credit report, both which take time to achieve. Having organized business financials, few to no past bond claims, and solid industry experience can make getting a freight broker bond less costly if your credit is not in the best shape.</p>
                </li>
            </div>
            <!-- /.auto insurance question --> 
          </div>
		  <div class="row">
            <div class="col-md-12 section-content" id="breaking"><!-- auto insurance question -->
				<ul>
                <li>
                  <h2>Breaking Down BMC-84 vs. BMC-85</h2>
                  <p>The FMCSA requires freight brokers to have a BMC-84 bond or, as an alternative, a <a href="/bmc-85">BMC-85 trust</a>. The bond option is often the first choice for licensed freight brokers because of the cost structure mentioned above. Instead of paying for the entire bond amount of $75,000, a BMC-84 bond also costs a percentage of that amount. When claims are made against the bond, you are responsible for repaying that amount back to the bond company. However, the lower up-front cost can be more appealing to brokers who are just starting in the industry or those who do not want to use cash to fund a BMC-85.</p>
				  <p>With the BMC-85 option, freight brokers establish a trust fund instead of taking out a broker bond. This trust fund is created with a deposit of $75,000, which is used as collateral for claims made in the future. When a claim takes place, funds are paid to the shipper or motor carrier making the claim out of the trust. These funds are managed by a custodian for a fee, charged each year. The BMC-85 trust fund may be a good option for large brokerage operations or those who simply do not want to get a BMC-84 bond.</p>
                </li>
				</ul>
            </div>
            <!-- /.auto insurance question --> 
          </div>
		  <div class="row">
            <div class="col-md-12 section-content" id="process"><!-- auto insurance question -->
              <ul>
                <li>
                  <h2>The Process for Getting a BMC-84 Bond</h2>
                  <p>If a bond is the right choice for your freight brokerage business, it is necessary to know the process for obtaining one. Licensed brokers need to first register with the FMCSA to gain their broker authority. Then, an application for a bond can be <a href="/freight-broker-bond-application">submitted with a surety agency</a>. After evaluating the factors that play a role in the pricing of a bond, you pay the percentage rate if your bond is approved. In many cases, your surety agency then electronically files your BMC-84 bond information with the FMCSA on your behalf. Once the bond certificate is filed, you have met the requirements to begin working as a freight broker. </p>
                </li>
            </div>
            <!-- /.auto insurance question --> 
          </div>
		  
        </div>
        <!--/right--> 
      </div>
      <!--/row-->
	  
	  
    </div>
  </div>
  <!-- insurance section --> 
  
  
  
</div>
<!-- /.Main container start-->
<?php include 'global_footer.php';?>