<!DOCTYPE html>
<html lang="en">
<head>

	<!-- Basic Page Needs
	================================================== -->
	<meta charset="utf-8">
   <title>Trust Fund (BMC-85) | Trans-Global Surety Bonds </title>

	<!-- Mobile Specific Metas
	================================================== -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

 <?php  include('global_scripts.php'); ?>
</head>
	
<body>

	<div class="body-inner">
	
	<!-- Header start -->
<?php  include('global_head.php'); ?>
<?php  include('global_nav.php'); ?>

	<div id="banner-area" class="banner-area" style="background-image:url(/images/banner/banner_freight.jpg)">
		<div class="banner-overlay"></div>
		<!-- Subpage title start -->
		<div class="banner-text text-center">
     		<div class="container">
	        	<div class="row">
	        		<div class="col-xs-12">
	        			<div class="banner-heading">
	        				<h1 class="banner-title">Trust Fund (BMC-85)</h1>
	        			</div>
			        	<ul class="breadcrumb">
			            <li>Home</li>
			            <li>Surety Bonds</li>
			            <li><a href="/bmc-85">Trust Fund (BMC-85)</a></li>
		          	</ul>
	        		</div>
	        	</div>
       	</div>
    	</div><!-- Subpage title end -->
	</div><!-- Banner area end --> 


	<section id="main-container" class="main-container">
		<div class="container">
			<div class="row">
				<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 right">
					<div class="sidebar sidebar-right">
						<div class="widget box red">
							<h3 class="widget-title">Free BMC-85 Quotes</h3>
							<p>Get a free, no obligation online quote.</p>
							<p style="text-align: center;"><a class="btn btn-dark" href="/freight-broker-bond-application">Get a Free Quote</a></p>
						</div>

					</div><!-- Sidebar end -->
				</div><!-- Sidebar Col end -->
							
				<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
					<h3 class="page-title">Breaking Down a BMC-85</h3>
					<div class="gap-20">&nbsp;</div>
					<p>A crucial component of becoming a licensed freight broker is obtaining a <a href="/freight-broker-bond">BMC-84 bond</a> or a BMC-85 trust fund. Either a bond or a trust can fulfill the Federal Motor Carrier Safety Administration (FMCSA) requirement for licensed brokers, but the two options work differently. Making the right choice for your freight brokerage business requires an understanding of how the BMC-85 trust fund works, how much it costs, and the steps necessary to put it in place. Comparing these characteristics of a BMC-85 freight broker trust to those of a BMC-84 freight broker bond is an essential part of the process.</p>
					<p>The FMCSA requires licensed freight brokers to post a security in the amount of $75,000. The security posted, either a bond or trust fund, is meant to protect the federal regulator from fraudulent or misleading business practices of the freight broker which may cause financial harm to the public. The $75,000 is a guarantee that the broker has reserves available to pay for valid claims over time, and it is necessary for as long as a freight broker holds a license to do business.</p>
					<p>The BMC-85 freight broker trust is an account established by the freight broker with a trust company or insured custodian. The account holds cash or easily accessible assets as collateral, in the amount of $75,000. This means that unlike a BMC-84 freight broker bond, a BMC-85 trust requires an upfront deposit to fund the trust account.</p>
					<p>When legitimate claims are submitted against a licensed freight broker, the trust pays those claims to cover any financial losses that may have been incurred. Any money taken out of the BMC-85 to pay for claims must be paid back into the trust so that it always meets the $75,000 minimum requirement.</p>
					<p>Freight brokers who have multiple claims risk spending a significant amount to maintain the BMC-85 trust fund, as well as the potential of a tarnished reputation in the business. Keeping complaints that result in paid claims to a minimum is necessary for licensed freight brokers who want to maintain a profitable, sustainable business.</p>
					
					<div class="gap-20">&nbsp;</div>

					<h3 class="page-content-title">What is the Cost of a BMC-85?</h3>
					<p>A BMC-85 trust fund comes with high costs, especially when compared to a BMC-84 freight broker bond. Freight brokers are required to pay the full $75,000 to fund the trust initially, and there may be administrative fees associated with maintaining the trust account over time. The ongoing fees for a trust fund cover the costs of maintaining the account, and they can range from a few hundred to a few thousand dollars per year. This differs from a BMC-84 bond is a significant way.</p>
					<p>Freight brokers who opt for a BMC-84 bond instead of the BMC-85 trust fund only pay a fraction of the $75,000 requirement. The expense for a freight broker bond varies depending on the credit history of the broker, his or her claims history, and details of the financial standing of the brokerage.</p>
					<p>If these factors are negative and do not show a positive track record of financial or claims management, the cost of the freight broker bond may be 10% of the bond amount. However, freight brokers with strong credit pay less, often between 1 and 5% of the bond. This often represents a more cost-effective way to meet the FMCSA requirement than a BMC-85 because the entire $75,000 does not fall on the shoulders of the broker initially.</p>
					
					<h3 class="page-content-title">Steps to Getting a BMC-85</h3>
					<p>Although a freight broker bond may be a more realistic option for licensed brokers from a cost perspective, not everyone meets the credit and business requirements necessary to obtain a BMC-84 bond. When this is the case, or when freight brokers prefer a trust fund, the BMC-85 is the alternative choice.</p>
					<p>Putting a BMC-85 trust fund in place as a freight broker is a relatively simple process. You first select the trust company with which you want the account to be established and managed over time. A trust company providing maintenance for a BMC-85 should be insured, and it should have a healthy financial standing. These factors of a trust company or custodian for a BMC-85 help ensure that when the funds in the trust account are needed to pay claims, they are readily available.</p>
					<p>After choosing a trust custodian, you will need to fund the account with $75,000. This is accomplished with cash in most cases, but some trust companies may allow other assets to be pledged as collateral to meet the full requirement. Once the BMC-85 trust is funded, the account will need to be maintained by the trust company.</p>
					
					<div class="gap-40"></div>

				</div><!-- Content Col end -->
			</div><!-- Main row end -->

		</div><!-- Conatiner end -->
	</section><!-- Main container end -->
	
    <!-- <section id="featured-tab-area" class="featured-tab-area">
		<div class="container">
			<div class="row text-center">
				<h3 class="title">
					We Are A Dedicated Firm
					<span class="title-head">Why Choose Saifway</span>
				</h3>
			</div><!--/ Title row end -->


			<!-- <div class="row">
				<div class="featured-tab clearfix">
					<ul class="nav nav-tabs col-sm-12 col-xs-12">
					  	<li class="">
					  		<a class="animated fadeIn" href="#tab_a" data-toggle="tab">
					  			<span class="tab-head">
									<i class="fa fa-globe pull-left">&nbsp;</i>
									<span class="tab-text-title">Trusted Since 1976</span>					
								</span>
					  		</a>
					  	</li>
					  	<li class="">
						  	<a class="animated fadeIn" href="#tab_b" data-toggle="tab">
						  		<span class="tab-head">
									<i class="fa fa-users pull-left">&nbsp;</i>
									<span class="tab-text-title">2.9M Users Never Wrong</span>					
								</span>
						  	</a>
						</li>
					 	<li class="">
						  	<a class="animated fadeIn" href="#tab_c" data-toggle="tab">
						  		<span class="tab-head">
									<i class="fa fa-android pull-left">&nbsp;</i>
									<span class="tab-text-title">Easy Quotes and Apps</span>					
								</span>
						  	</a>
						</li>

						<li class="">
						  	<a class="animated fadeIn" href="#tab_d" data-toggle="tab">
						  		<span class="tab-head">
									<i class="fa fa-life-ring pull-left">&nbsp;</i>
									<span class="tab-text-title">Secure and Stable</span>					
								</span>
						  	</a>
						</li>

						<li class="active">
						  	<a class="animated fadeIn" href="#tab_e" data-toggle="tab">
						  		<span class="tab-head">
									<i class="fa fa-user-secret pull-left">&nbsp;</i>
									<span class="tab-text-title">24/7 With Real Person</span>					
								</span>
						  	</a>
						</li>

					</ul>
					<div class="tab-content col-sm-12 col-xs-12">
				        <div class="tab-pane animated fadeInRight" id="tab_a">
				        	<img class="img-responsive pull-right" src="<?PHP echo $ImageUrl;?>tab/featured-tab1.jpg" alt="">
				        	<div class="tab-wrapper">
				        		<h3 class="tab-content-title">A History of Trust and Dependability</h3>
					         <p>None quis nibh vel erat tincidunt pretium. In sit amet massa sapien. Vestibulum diam turpis, gravida in lobortis id, ornare a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sagittis nulla non elit dignissim suscipit. Duis lorem nulla, eleifend. Ut urna dui, interdum non blandit sed, hendrerit ultricies mi. Aliquam at scelerisque ligula. Curabitur id laoreet velit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sagittis nulla non elit dignissim suscipit.</p>
					         <ul class="list-round-arrow">
									<li>There are many variations of passages of Lorem Ipsum</li>
									<li>All the Lorem Ipsum generators on the Internet</li>
									<li>Tend to repeat predefined chunks as necessary</li>
									<li>The point of using Lorem Ipsum is thatl</li>
								</ul>
				        	</div>
				        </div>

				        <div class="tab-pane animated fadeInLeft" id="tab_b">
				            <img class="img-responsive pull-left" src="<?PHP echo $ImageUrl;?>tab/featured-tab2.png" alt="">
				            <h3>Harmony from the World heart</h3>
				            <h4>Simply dummy text of the printing</h4>
								<p>None quis nibh vel erat tincidunt pretium. In sit amet massa sapien. Vestibulum diam turpis, gravida in lobortis id, ornare a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sagittis nulla non elit dignissim suscipit. Duis lorem nulla, eleifend.</p>		
								<p>Ut urna dui, interdum non blandit sed, hendrerit ultricies mi. Aliquam at scelerisque ligula. Curabitur id laoreet velit.</p>					 
				        </div>

				        	<div class="tab-pane animated fadeInLeft" id="tab_c">
				            <p class="tab-icon pull-left"><i class="fa fa-android">&nbsp;</i></p>
				            <h3>Harmony from the World heart</h3>
								<h4>Simply dummy text of the printing</h4>
								<p>None quis nibh vel erat tincidunt pretium. In sit amet massa sapien. Vestibulum diam turpis, gravida in lobortis id, ornare a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sagittis nulla non elit dignissim suscipit. Duis lorem nulla, eleifend.</p>
								<p>Ut urna dui, interdum non blandit sed, hendrerit ultricies mi. Aliquam at scelerisque ligula. Curabitur id laoreet velit.</p>
				        	</div>	

				        	<div class="tab-pane animated fadeInLeft" id="tab_d">
				            <p><img class="pull-right img-responsive" src="<?PHP echo $ImageUrl;?>tab/featured-tab3.png" alt=""></p>
								<h3>Harmony from the World heart</h3>
								<p>None quis nibh vel erat tincidunt pretium. In sit amet massa sapien. Vestibulum diam turpis, gravida in lobortis id, ornare a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sagittis nulla non elit dignissim suscipit. Duis lorem nulla, eleifend.</p>
								<p>Ut urna dui, interdum non blandit sed, hendrerit ultricies mi. Aliquam at scelerisque ligula. Curabitur id laoreet velit.</p>
				        	</div>

				        	<div class="tab-pane animated fadeInLeft active" id="tab_e">
				            <p><img class="pull-left img-responsive" src="<?PHP echo $ImageUrl;?>tab/featured-tab4.png" alt=""></p>
								<h3>Harmony from the World heart</h3>
								<p>None quis nibh vel erat tincidunt pretium. In sit amet massa sapien. Vestibulum diam turpis, gravida in lobortis id, ornare a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sagittis nulla non elit dignissim suscipit. Duis lorem nulla, eleifend.</p>
								<p>Ut urna dui, interdum non blandit sed, hendrerit ultricies mi. Aliquam at scelerisque ligula. Curabitur id laoreet velit.</p>
				        	</div>
		
					</div><!-- tab content -->
	    		<!-- </div><!-- Featured tab end -->
			<!-- </div><!--/ Content row end -->

		<!-- </div><!--/ Container end -->
	<!-- </section><!-- Featured tab end -->
<?php  include('global_footer.php'); ?>